---
docs: true
icon: "\U0001F9E0"
summary: The mental model for users, wikis, pages, and URLs.
source_wiki: docs
source_wiki_source: How_Wittle_Works.md
name: How Wittle Works
---

## The model

- A **User** owns many **Wikis**
- A **Wiki** owns many **Pages**

## URLs

Wittle uses a simple URL shape:

- A wiki: `/USER/WIKI`
- A page: `/USER/WIKI/PAGE`

For example:

- `/wittle/docs`
- `/wittle/docs/Links`

## Page names and URL names

Page names can contain spaces, but URLs use underscores:

- “Main Page” becomes `Main_Page`
- “Getting Started” becomes `Getting_Started`

Links and page lookups are **case-insensitive**.

## Rendering

Pages are written in **Markdown** and rendered to HTML.

- HTML is sanitized for safety.
- Code blocks, lists, headings, quotes, etc. work as you’d expect.

## Missing pages

If you click a link to a page that doesn’t exist yet, you’ll see a “Page not found” screen.

If you have permission to edit that wiki, you’ll get a **Create this page** button.
